package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.generationaleatoire;

import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import java.util.LinkedHashMap;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement : Gnration normale d'un nombre pseudo-alatoire
 *
 */
public class GenerationNormale{

	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(GenerationNormale.class);
	
	/**
	 * Renvoie le rsultat de l'opration
	 * @param librairie Librairie PKCS#11  utiliser
	 * @param idSession Identifiant de la session
	 * @return Rsultat de l'opration
	 * @throws ExceptionTraitement
	 */
	public static Resultat traitementP11(PKCS11 librairie, long idSession) throws ExceptionTraitement {

		try {
		
			if(librairie != null) {
			
				ResultatInfo resultat = new ResultatInfo("Gnration normale d'un nombre pseudo-alatoire (C_GenerateRandom)");
				LinkedHashMap<String,String> infos = new LinkedHashMap<String,String>();
				resultat.setInfos(infos);
				
				try {
					
					byte[] nbAleatoire = new byte[6];
					
					// Traitement  tester
					librairie.C_GenerateRandom(idSession, nbAleatoire);
					
					if(nbAleatoire != null)
						// Formatage du rsultat
						infos.put("Nombre aleatoire gnr",TraitementsUtil.getHexadecimal(nbAleatoire,null));
					else {
						
						// Si le nombre alatoire gnr est nul on lve l'exception
						log.error("L'operation a retourne un nombre aleatoire nul");
						throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_GENERATIONALEATOIRE_NORMALE, "L'opration a retourn un nombre alatoire nul");
						
					}
					
				} catch (PKCS11Exception e) {
					
					log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
					resultat.setCodeRetour(e.getErrorCode());
					
				}
				
				return resultat;
		
			} else {
				
				// Si la librairie est nulle il est impossible de raliser l'opration
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_GENERATIONALEATOIRE_NORMALE, "La librairie est nulle");
				
			}

		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue on la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_GENERATIONALEATOIRE_NORMALE, "Une erreur inattendue est survenue");
			
		}
	}
}
